<?php
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    //PAGINA PER LO SCARICAMENTO DEI FILE, PRENDE IN INPUT L'ID E POI FA SCARICARE IL FILE AGGIORNANDO IL CAMPO numeroDownload nel database
    include "include/includeBase.php";
    include "../classi/Notifica.php";
    
    //i dati del database sono definiti nel file costanti.php
    $geecomDb = new DbManager($costantiDatabase);
    
    if(isset($_GET["idVersione"])) {    
        $idVersione  = filter_input(INPUT_GET,"idVersione",FILTER_SANITIZE_NUMBER_INT);
        $versioneDocumento = $geecomDb->leggiSingolaRiga("geecD_versioniDocumento", $idVersione);
        
        $idDocumento = $versioneDocumento["idDocumento"];
    }
    else {    
        $idDocumento = filter_input(INPUT_GET,"idDocumento",FILTER_SANITIZE_NUMBER_INT);
        
        $queryUltimaVersione = "SELECT * FROM geecD_versioniDocumento WHERE idDocumento = {$idDocumento} ORDER BY id DESC LIMIT 1";
        $risUltimaVersione   = $geecomDb->eseguiQueryLettura($queryUltimaVersione);
        $versioneDocumento  = $risUltimaVersione->fetch_assoc();
    }

    $numeroDownload = $versioneDocumento['numeroDownload'];
    $numeroDownload ++; //il file sta per essere scaricato un'altra volta quindi lo incremento di uno

    $query_aggiornamento = "UPDATE geecD_versioniDocumento SET numeroDownload='$numeroDownload' WHERE id='{$versioneDocumento["id"]}'"; //eseguo la query per aggiornare il campo
    $geecomDb->eseguiQueryScrittura($query_aggiornamento);

    $datiDocumento = $geecomDb->leggiSingolaRiga("geecD_documenti", $idDocumento);
    
    if($impostazioni["inviaNotificaScaricamento"]=="si" && $_SESSION["geecomAdmin_ruolo"]!="super admin") {        
        $notifica = new Notifica($geecomDb, 0);
        $notifica->setProdotto("Doc");
        $notifica->setTesto($_SESSION["geecomAdmin_nomeCognome"]." ha scaricato l\'ultima versione del documento ".filter_var($datiDocumento["nome"],FILTER_SANITIZE_ADD_SLASHES));
        $notifica->crea();
    }
    $nomeDocumento = substr(pathinfo($versioneDocumento["percorsoFile"], PATHINFO_FILENAME).".".pathinfo($versioneDocumento["percorsoFile"],PATHINFO_EXTENSION), 13);

    header('Content-type: octet/stream');
    header('Content-disposition: attachment; filename='.$nomeDocumento.';');
    header('Content-Length: '.filesize("../".$versioneDocumento['percorsoFile']));
    readfile("../".$versioneDocumento['percorsoFile']);